;
;     This program implements  FIR filter:
;
;
;
;      AIC set-up parameters. For DSK running at 40 mhz, the sampling
;      frequency is 10,000,000/2/TA/TB for transmit and is
;      10,000,000/2/RA/RB for receive. The max value for TA,TB.RA,RB is 63
;      since the registers are 6 bits.


         .ds      0400h
TA       .word    31         ; This set up of AIC registers give
RA       .word    31         ; a sampling freq of 5203 Hz 
TB       .word    31         ;
RB       .word    31         ;
;TA       .word    16         ; This set up of AIC registers give
;RA       .word    16         ; a sampling freq of 10,081 Hz
;TB       .word    31         ;
;RB       .word    31         ;
TAp      .word    1          ;  
RAp      .word    1          ;
AIC_CMD  .word    028h
y2	 .word	  0


	.include  "coeff.asm"
	.include  "mmregs.asm"

        .ps     0FA0Ah
        B       RINT
        B       XINT

        .ps     0FB00h          ;
        .entry                  ;
        ;--------------------------------------------------------------

        dint

        call    AIC_RS
        call    AIC_SET

        nop
        nop
        nop
        nop
        nop


        ldpk    0
        lack    010h   ; This turns on receive interrupt only
        sacl    IMR


        ssxm
        spm     0
        conf    1

        eint

loop                          ; a main program would go here
                              ;
        b       loop          ;



RINT
        dint
        rovm
        ldpk     DRR         ; point to memory mapped serial port recieve reg
        lac      DRR         ; load accumulator with word received from AIC
        sfr                  ; shift right twice to remove unused lsb's
        sfr                  ;
        ldpk     XN0         ; store the value of received word to a variable
        sacl     XN0         ;

        larp     0
        lrlk     AR0,XNLAST        ; load AR0 with address of last delay element
        lrlk     AR1,H_LAST        ; load AR1 with address of last filter coeffic
        lark     AR2,FILT_SIZE - 2 ; load AR2 with loop counter


        zac
        lt       *-,AR1            ;
        mpy      *-,AR0            ;

        ldpk     0

begin   ltd      *-,AR1            ;
        mpy      *-,AR2            ;
        banz     begin,*-,AR0      ;

        apac

        ldpk     y2
        sach     y2,1
        lac      y2


        sfl
        sfl
        andk     0fffch


        ldpk     DXR
        sacl     DXR         ; write output word to transmit register

        eint
        ret                  ;


XINT    ret











******************************************************************
AIC_RS:
         dint                    ; disable interrupts
         ldpk    0
         lalk    255             ; enable global memory
         sacl    GREG            ; set up minimum global data words of 256

         ldpk    8                ;get into high data memory
         rptk    10
         lac     02h              ;try to load accumulator from high memory
         eint                     ;this will toggle the br\ pin and reset
         ret                      ;the AIC

AIC_SET: ldpk   0                 ;
         lack   020h              ;ACCU_hi = AIC_1   ACCU_lo = AIC_2
         ssxm                     ;
         sacl   IMR               ;XMIT interrupt
         eint
         ;-----------------------
         ldpk   TA
         lac    TA,9              ;
         add    RA,2              ;
         call   AIC_2nd           ;
         ;------------------------
         ldpk   TAp
         lac    TAp,9              ;
         add    RAp,2              ;
         addk   01h               ;
         call   AIC_2nd           ;
         ;------------------------
         ldpk   TB
         lac    TB,9              ;
         add    RB,2              ;
         addk   02h               ;
         call   AIC_2nd           ;
         ;------------------------
         ldpk   AIC_CMD
         lac    AIC_CMD,2         ;
         addk   03h               ;
         call   AIC_2nd           ;
         ;------------------------
         ret
;----------------------------------------------------------------
AIC_2nd: ldpk   0                 ;
         sach   DXR               ;
         idle                     ;
         adlk   6,15              ;0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
         sach   DXR               ;
         idle                     ;ACCU_hi requests 2nd XMIT
         sacl   DXR               ;
         idle                     ;ACCU_lo sets up registers
         zac                      ;
         sacl   DXR               ;make sure the word got sent
         idle                     ;
         ret                      ;



	.end
